<!DOCTYPE html>
<html>
<head>
    <title>IoT Device Simulator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .device {
            margin: 10px 0;
            display: flex;
            align-items: center;
        }
        .device span {
            margin-right: 10px;
        }
        .status {
            display: inline-block;
            width: 60px;
            text-align: center;
        }
        .icon {
            width: 120px; /* Adjust the size as needed */
            height: 120px; /* Adjust the size as needed */
            margin-right: 10px;
            transition: opacity 0.3s ease;
        }
        .Metericon{
            width: 200px; /* Adjust the size as needed */
            height: 200px; /* Adjust the size as needed */
            margin-right: 10px;
            transition: opacity 0.3s ease;
        }
        .icon.hidden {
            display: none;
        }
        #logs {
            margin-top: 20px;
        }
        #logs div {
            margin-bottom: 5px;
        }
        #meter {
            margin-top: 20px;
        }
        #meter span {
            /* display: block; */
            margin: 5px 0;
        }
        table {
            border-collapse: collapse;
        }
        table td {
            border: 1px solid gray;
        }
    </style>
</head>
<body>
    <h1>Devices</h1>
    <table style="width: 800px; border: 1px solid gray;">
        <tr>
            <td>
                <div class="device">
                    <img id="lightIcon" class="icon" src="{{asset('assets')}}/img/light_off.png" alt="Light">
                    <span><span id="lightStatus" class="status">Off</span></span>
                </div>
                <div class="device">
                    <img id="fanIcon" class="icon" src="{{asset('assets')}}/img/fan_off.png" alt="Fan">
                    <span><span id="fanStatus" class="status">Off</span></span>
                </div>
            </td>
            <td>
                <div id="meter">
                    <img id="meterIcon" class="Metericon" src="{{asset('assets')}}/img/meter_off.png" alt="Meter">
                    <h2>Electricity Meter</h2>
                    <p>Status: <span id="meterStatus">OFF</span></p>
                    <p>Current c1: <span id="currentC1">0</span> A</p>
                    <p>Current c2: <span id="currentC2">0</span> A</p>
                    <p>Current c3: <span id="currentC3">0</span> A</p>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <div id="logs">
                    <h2>Command Logs</h2>
                    <!-- Logs will appear here -->
                </div>
            </td>
        </tr>
    </table>

    <script>
        const socket = new WebSocket('ws://192.168.1.116:8080');
        let isMeterOn = false; // Flag to control current generation

        socket.onopen = () => {
            console.log('Connected to WebSocket server');
        };

        socket.onmessage = (event) => {
            const message = event.data.trim();
            const logsDiv = document.getElementById('logs');
            logsDiv.textContent = '[' + new Date().toLocaleTimeString() + '] Received Command: ' + message;
            handleDeviceMessage(message);
        };

        socket.onerror = (error) => {
            console.error('WebSocket error:', error);
        };

        function toggleDevice(device) {
            const message = device === 'light' ? 'TOGGLE_LIGHT' : 'TOGGLE_FAN';
            socket.send(message);
        }

        function handleDeviceMessage(message) {
            const lightStatus = document.getElementById('lightStatus');
            const fanStatus = document.getElementById('fanStatus');
            const meterStatus = document.getElementById('meterStatus');
            const meterIcon = document.getElementById('meterIcon');
            const lightIcon = document.getElementById('lightIcon');
            const fanIcon = document.getElementById('fanIcon');

            if (message === 'LIGHT_ON') {
                lightStatus.textContent = 'On';
                lightIcon.src = '{{asset("assets")}}/img/light_on.gif'; // Use actual GIF URL
            } else if (message === 'LIGHT_OFF') {
                lightStatus.textContent = 'Off';
                lightIcon.src = '{{asset("assets")}}/img/light_off.png'; // Use actual GIF URL
            } else if (message === 'FAN_ON') {
                fanStatus.textContent = 'On';
                fanIcon.src = '{{asset("assets")}}/img/fan_on.gif'; // Use actual GIF URL
            } else if (message === 'FAN_OFF') {
                fanStatus.textContent = 'Off';
                fanIcon.src = '{{asset("assets")}}/img/fan_off.png'; // Use actual GIF URL
            } else if (message === 'MET_ON') {
                meterStatus.textContent = 'On';
                meterIcon.src = '{{asset("assets")}}/img/meter_on.gif'; // Use actual GIF URL
                isMeterOn = true; // Start generating currents
            } else if (message === 'MET_OFF') {
                meterStatus.textContent = 'Off';
                meterIcon.src = '{{asset("assets")}}/img/meter_off.png'; // Use actual GIF URL
                isMeterOn = false; // Stop generating currents
            }
        }

        function generateDynamicCurrents() {
            if (!isMeterOn) return; // Do nothing if meter is off

            // Simulate three dynamic current values
            const c1 = (Math.random() * 10).toFixed(2);
            const c2 = (Math.random() * 10).toFixed(2);
            const c3 = (Math.random() * 10).toFixed(2);

            // Update display
            document.getElementById('currentC1').textContent = c1;
            document.getElementById('currentC2').textContent = c2;
            document.getElementById('currentC3').textContent = c3;

            const data = {
                c1: c1,
                c2: c2,
                c3: c3
            };

            // Send JSON string to WebSocket server
            socket.send(JSON.stringify(data));
        }

        // Update meter every second only if the meter is on
        setInterval(generateDynamicCurrents, 1000);
    </script>
</body>
</html>
